import numpy as np 
import pandas as pd 
import matplotlib.pyplot as plt 
from datetime import datetime
# Fonction pour lire le fichier et retourner les données
def reader(file_path):
    try:
        # Lecture du fichier CSV
        data = np.genfromtxt(file_path, delimiter=";", encoding="ISO-8859-1", dtype=None, names=True, invalid_raise=False)

        # Vérification des colonnes
        header = data.dtype.names
        required_columns = {'Date', 'HStart', 'HEnd', 'Groupe', 'Location', 'Summary'}
        if not required_columns.issubset(header):
            raise ValueError("Les colonnes requises sont introuvables dans le fichier CSV.")

        return data

    except Exception as e:
        print(f"Erreur : {e}")
        return None

# Fonction pour calculer le total des heures pour chaque matière en utilisant numpy
def Heure_par_matiere(data):
    # Initialiser le dictionnaire pour les heures par matière
    subject_hours = {
        'RLAN1': {'CM': 0, 'TD': 0, 'TP': 0},
        'Prog1': {'CM': 0, 'TD': 0, 'TP': 0},
        'Elec1': {'CM': 0, 'TD': 0, 'TP': 0},
        'Math-Trans1': {'CM': 0, 'TD': 0, 'TP': 0},
        'SAE1.01': {'CM': 0, 'TD': 0, 'TP': 0},
        'Anglais1': {'CM': 0, 'TD': 0, 'TP': 0},
        'Math-Signal1': {'CM': 0, 'TD': 0, 'TP': 0},
        'Archi-Sys1': {'CM': 0, 'TD': 0, 'TP': 0},
        'SAE1.02': {'CM': 0, 'TD': 0, 'TP': 0},
        'Web1': {'CM': 0, 'TD': 0, 'TP': 0},
        'Archi-Rés1': {'CM': 0, 'TD': 0, 'TP': 0},
        'Telecom1': {'CM': 0, 'TD': 0, 'TP': 0},
        'SAE1.05': {'CM': 0, 'TD': 0, 'TP': 0},
        'Init-Rés1': {'CM': 0, 'TD': 0, 'TP': 0},
        'SAE1.04': {'CM': 0, 'TD': 0, 'TP': 0},
        'SAE1.03': {'CM': 0, 'TD': 0, 'TP': 0},
        'Com1': {'CM': 0, 'TD': 0, 'TP': 0},
        'Syst1': {'CM': 0, 'TD': 0, 'TP': 0},
        'PPP1': {'CM': 0, 'TD': 0, 'TP': 0},
        'Gest_projet': {'CM': 0, 'TD': 0, 'TP': 0}
    }

    # Parcourir chaque ligne des données
    for row in data:
        start_time = datetime.strptime(row['HStart'], '%H:%M:%S')
        end_time = datetime.strptime(row['HEnd'], '%H:%M:%S')
        duration = (end_time - start_time).seconds / 3600  # Convertir les secondes en heures

        subject = row['Summary'].strip()
        if subject in subject_hours:
            if "TD" in row['Groupe']:
                subject_hours[subject]['TD'] += duration

            elif "TP" in row['Groupe']:
                subject_hours[subject]['TP'] += duration

            elif "Cours" in row['Groupe']:
                subject_hours[subject]['CM'] += duration
            
        

    return subject_hours

# Chemin du fichier d'entrée
input_file_path = 'C:/Users/ligut/CSV Ligutti3.csv'

# Exécution de la fonction reader
data = reader(input_file_path)

# Calculer le total des heures pour chaque matière
subject_hours = Heure_par_matiere(data)

print("Total des heures pour chaque matière :")

Total = 0
cmtotal = 0
tptotal = 0
tdtotal = 0
for subject in subject_hours:
    cm_hours = subject_hours[subject]['CM']
    td_hours = subject_hours[subject]['TD']
    tp_hours = subject_hours[subject]['TP']
    Total += cm_hours + td_hours + tp_hours
    cmtotal += cm_hours
    tptotal += tp_hours
    tdtotal += td_hours
    
    print(f"{subject:<15} - CM: {cm_hours:<5} heures | TD: {td_hours:<5} heures | TP: {tp_hours:<5} heures | Total: {cm_hours+td_hours+tp_hours}")
print(f"TotCM : {cmtotal} | TotTP : {tptotal} | TotTD : {tdtotal})")

print(Total)

df = pd.DataFrame(subject_hours).T.reset_index().rename(columns={'index': 'Matière'}) 

# Calculer les heures totales pour chaque matière 
df['Total'] = df['CM'] + df['TD'] + df['TP'] 
#Afficher les résultats 
print(df) 
# Créer le graphique 
plt.figure(figsize=(12, 8)) 
plt.bar(df['Matière'], df['Total'], color='skyblue') 
plt.xlabel('Matières') 
plt.ylabel('Nombre d\'heures par an') 
plt.title('Nombre d\'heures consacrées par matière en un an') 
plt.xticks(rotation=45) 
plt.tight_layout() 
plt.show()